string GetDescription()
{
	return "Creates a random melody line with repetitve rythm and cenetered aroun the tonic of the chord. \nLast bar gets an ending (single note)";
}

int first_pitch = 0;
int last_pitch = 0;

void SetFirstPitch(int f)
{
	first_pitch = f;
	last_pitch = f;	
}	

int GetNextPitch(int p)
{
	int cur_pitch = p;
	if (cur_pitch - 7 > last_pitch) cur_pitch -= 12;
	last_pitch = cur_pitch + RndInt(-3,3);
	return cur_pitch;
}

void Render(RenderPart @p)
{
	SetFirstPitch(p.GetHarmonicEventPitch(0,0));
	
	int mode = RndInt(0,1);
	
	if (p.GetParam("mode").toInt() > 0) mode = p.GetParam("mode").toInt()-1;
		
	if (mode == 0)
	{
		double delta = 0.5;
		for (int i = 0; i < p.GetHarmonicEvents(); i++)
		{
			if (RndInt(0,5) == 0 || i == p.GetHarmonicEvents()-1)
			{
				p.AddNote(p.GetHarmonicEventStart(i), p.GetHarmonicEventEnd(i), GetNextPitch(p.GetHarmonicEventPitch(i,0)) , RndInt(122,127));	
			}
			else
			{
				p.AddNote(p.GetHarmonicEventStart(i), CreateTime(p.GetHarmonicEventEnd(i).m_Bar,p.GetHarmonicEventEnd(i).m_Pos-delta), GetNextPitch(p.GetHarmonicEventPitch(i,0)) , RndInt(122,127));	
				p.AddNote(CreateTime(p.GetHarmonicEventEnd(i).m_Bar,p.GetHarmonicEventEnd(i).m_Pos-delta), p.GetHarmonicEventEnd(i), GetNextPitch(p.GetHarmonicEventPitch(i,RndInt(0,2))-12*RndInt(0,1)) , RndInt(122,127));	
			}
		}		
	}
	else
	{
		
		double len = RndFloat(0.5, 1.0);
		if (RndInt(0,1) == 0) len = 0.98;
		
		int len_mode = RndInt(0,1);
		
		double speed = 1;
		if (p.GetTempo() < 90) speed = 0.5;
		
	
		for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
		{
			for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=speed)
			{
				Time t = CreateTime(i,m);
				int vel = 127;
				if (m % 2 == 1) vel = 122;
				
				int harm = p.GetHarmonic(t);
				
				if (harm == p.GetHarmonicEvents()-1)
				{
					p.AddNote(p.GetHarmonicEventStart(p.GetHarmonicEvents()-1), p.GetHarmonicEventEnd(p.GetHarmonicEvents()-1), GetNextPitch(p.GetHarmonicEventPitch(p.GetHarmonicEvents()-1,0)) , RndInt(115,126));	
					return;
				}
				
				Time t2 = t;
				if (len_mode == 0) t2.m_Pos += len * speed;
				else t2.m_Pos += RndFloat(0.5, 1.0) * speed;
								
				if (RndInt(0,2) != 0) p.AddNote(t, t2, GetNextPitch(p.GetHarmonicEventPitch( harm,0)) , RndInt(vel-15,vel));	
				else p.AddNote(t, t2, GetNextPitch(p.GetHarmonicEventPitch( harm,RndInt(-2,2))) , RndInt(vel-15,vel));	
			}	
		}
	}
}